sampler texture0 : register(s0);
				
float4x4 WorldViewProjectionTransform  : WORLDVIEWPROJ;

float fTime = 1.f;
float fDuration = 1.f;
float fAlphaDirect = 1.f;

struct VS_OUTPUT 
{
   float4 Position   : POSITION0;
   float2 TexCoord   : TEXCOORD0;
};

struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};

VS_OUTPUT vertexMain(
				float4 vPosition : POSITION,
				float2 texCoord0 : TEXCOORD0)
{
   VS_OUTPUT Output; 

   Output.Position = mul(vPosition, WorldViewProjectionTransform);
   Output.TexCoord = texCoord0;   

   return Output;
}

PS_OUTPUT pixelMain(VS_OUTPUT In)
{
	float fAlpha = saturate(fTime / fDuration) - saturate((fTime - (1.f - fDuration)) / fDuration);
	fAlpha *= fAlphaDirect;
	
	PS_OUTPUT result;
	result.RGBColor = tex2D(texture0, In.TexCoord);
	result.RGBColor.a = min(result.RGBColor.a, fAlpha);
	return result;
}
